export class CapacitorElectron {
    constructor() {
        this.Plugins = {};
        this.platform = "electron";
        this.isNative = false;
        // Build a proxy for the Plugins object that returns the "Noop Plugin"
        // if a plugin isn't available
        this.Plugins = new Proxy(this.Plugins, {
            get: (target, prop) => {
                if (typeof target[prop] === "undefined") {
                    let thisRef = this;
                    return new Proxy({}, {
                        get: (_target, _prop) => {
                            if (typeof _target[_prop] === "undefined") {
                                return thisRef.pluginMethodNoop.bind(thisRef, _target, _prop, prop);
                            }
                            else {
                                return _target[_prop];
                            }
                        },
                    });
                }
                else {
                    return target[prop];
                }
            },
        });
    }
    pluginMethodNoop(_target, _prop, pluginName) {
        return Promise.reject(`${pluginName} does not have electron implementation.`);
    }
    getPlatform() {
        return this.platform;
    }
    isPluginAvailable(name) {
        return this.Plugins.hasOwnProperty(name);
    }
    convertFileSrc(filePath) {
        return filePath;
    }
    handleError(e) {
        console.error(e);
    }
}
//# sourceMappingURL=runtime.js.map